#include <iostream>
#include <vector>
#include <algorithm>
#include <deque>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    cin >> n;

    deque<long long> North, South;
    for (int i = 0; i < n; i++) {
        long long x;
        cin >> x;
        if (x > 0) North.push_back(x);
        else South.push_back(-x);
    }

    sort(North.begin(), North.end());
    sort(South.begin(), South.end());

    string res = "";
    int last_move = 0;
    int eliminated = 0;

    long long t = 0;
    long long pos = 0;

    while (res.length() < 1000000) {
        int best_move = 0;
        
     bool north_danger = false;
        if (!North.empty() && North.front() - pos - t <= 0) break; 
        
        bool south_danger = false;
        if (!South.empty() && South.front() + pos - t <= 0) break;

        long long distN = North.empty() ? 2e18 : (North.front() - pos - t);
        long long distS = South.empty() ? 2e18 : (South.front() + pos - t);

        if (distN <= 1 && distS <= 1 && North.size() > 0 && South.size() > 0) {
            if (last_move != 1) best_move = 1;
            else if (last_move != 2) best_move = 2;
        } 
        else if (distN < distS) {
            if (last_move != 1) best_move = 1;
            else {

                if (distS > 1) best_move = 2;
                else best_move = 3;
            }
        } 
        else {
            if (last_move != 2) best_move = 2;
            else {
                if (distN > 1) best_move = 1;
                else best_move = 3;
            }
        }

        if (best_move == 1) {
            if (!North.empty()) {
                North.pop_front();
                eliminated++;
            }
        } else if (best_move == 2) {
            if (!South.empty()) {
                South.pop_front();
                eliminated++;
            }
        } else if (best_move == 3) {
            pos++;
        }

        t++;
        if (!North.empty() && North.front() - pos - t < 0) break;
        if (!South.empty() && South.front() + pos - t < 0) break;

        res += (char)(best_move + '0');
        last_move = best_move;

        if (North.empty() && South.empty()) break;
    }

    cout << eliminated << "\n";
    cout << res << "\n";

    return 0;
}